<?php 
include 'koneksi.php';
include 'header1.php';

// **Retrieve Data from Database**
$bobot = query("SELECT * FROM bobot1");
$alternatif = query("SELECT * FROM mahasiswa");

// **Define Criteria Names**
$kriteria_nama = [
    "c1" => "Content Relevance",
    "c2" => "Presentation Quality",
    "c3" => "Audiovisual Quality",
    "c4" => "Interactivity & Engagement",
    "c5" => "Frequency of Use",
    "c6" => "Access Barriers",
    "c7" => "Impact on Understanding"
];

?>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-4">
            <h2 class="text-center mb-4 py-3 bg-light rounded" style="font-size: 28px"><strong>CRITERIA WEIGHTS DATA AND ALTERNATIVE SCORES</strong></h2>

            <!-- **Criteria Weights Table** -->
            <div class="card shadow-sm w-100 mt-4">
                <div class="card-header bg-primary text-white text-center align-middle">
                    <h4><i class="fas fa-balance-scale"></i>  Criteria and Weights</h4>
                </div>
                <div class="card-body">
                    <?php if (!empty($bobot)) : ?>
                        <div class="table-responsive">
                            <table class="table table-bordered text-center w-100">
                                <thead class="table-primary">
                                    <tr>
                                        <th>Criteria Code</th>
                                        <th>Criteria Name</th>
                                        <th>Weight</th>
                                    </tr>
                                </thead>
                                <tbody class="table-light">
                                    <?php foreach ($bobot[0] as $key => $value) : ?>
                                        <?php if (isset($kriteria_nama[$key])) : ?>
                                            <tr>
                                                <td class="align-middle"><?= strtoupper($key); ?></td>
                                                <td class="align-middle"><?= $kriteria_nama[$key]; ?></td>
                                                <td class="align-middle"><?= $value; ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else : ?>
                        <div class="alert alert-danger text-center">Data not available!</div>
                    <?php endif; ?>
                </div>
            </div>
            </div>
            <br>

            <!-- **Alternative Data Table** -->
            <div class="card shadow-sm w-100 mt-4">
                <div class="card-header bg-primary text-white text-center align-middle">
                    <h4><i class="fas fa-table"></i>  Alternative Scores</h4>
                </div>
                <div class="card-body">
                    <?php if (!empty($alternatif)) : ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover w-100">
                                <thead class="table-primary text-center">
                                    <tr>
                                        <th style="width: 5%;">No.</th>
                                        <?php foreach ($alternatif[0] as $key => $value) : ?>
                                            <?php if (!in_array($key, ['id', 'nama', 'nim', 'email'])) : ?>
                                                <th><?= strtoupper($key); ?></th>
                                            <?php endif; ?>
                                        <?php endforeach; ?>

                                    </tr>
                                </thead>
                                <tbody class="table-light text-center">
                                    <?php $no = 1; ?>
                                    <?php foreach ($alternatif as $row) : ?>
                                        <tr>
                                            <td class="align-middle"><?= $no++; ?></td>
                                            <?php foreach ($row as $key => $value) : ?>
                                                <?php if (!in_array($key, ['id', 'nama', 'nim', 'email'])) : ?>
                                                    <td class="align-middle"><?= $value; ?></td>
                                                <?php endif; ?>
                                            <?php endforeach; ?>

                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else : ?>
                        <div class="alert alert-danger text-center">Effectiveness data not available!</div>
                    <?php endif; ?>
                    <br><br>
                </div>
                           <!-- **Start Calculation Process Button** -->
                <div class="text-center">
                    <a href="proses1.php" class="btn btn-lg btn-outline-success">
                        <i class="fas fa-calculator"></i> Start Calculation Process
                    </a>
                </div>
                <br><br>
                </div>  
        <br><br>
        <br><br>

    </main>
</div>

<!-- 🔥 Ensure navigation can open and doesn't freeze -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let sidebarToggle = document.querySelector("#sidebarToggle");
        if (sidebarToggle) {
            sidebarToggle.addEventListener("click", function (e) {
                e.preventDefault();
                document.body.classList.toggle("sb-sidenav-toggled");
            });
        }
    });
</script>
